-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

THInfoLayer = {}
local THInfoLayer_mt = THUtils.createClass(THInfoLayer, InfoLayer)
function THInfoLayer.new(name, customEnv, baseDirectory, customMt)
    customMt = customMt or THInfoLayer_mt
    if g_thModManager ~= nil then
        local modData = g_thModManager:getLoadedMod(customEnv, true)
        if modData == nil then
            return
        end
        customEnv = modData.name
    elseif type(customEnv) ~= THValueType.STRING or customEnv == "" then
        THUtils.errorMsg(true, THMessage.ARGUMENT_INVALID, "customEnv", customEnv)
        return
    end
    if THUtils.argIsValid(THUtils.validateId(name), "name", name)
        and THUtils.argIsValid(type(baseDirectory) == THValueType.STRING, "baseDirectory", baseDirectory)
        and THUtils.argIsValid(type(customMt) == THValueType.TABLE, "customMt", customMt)
    then
        local self = InfoLayer.new(name, baseDirectory)
        if self ~= nil then
            THUtils.registerValue(self, "modName", customEnv)
            THUtils.registerValue(self, "modPath", baseDirectory)
            THUtils.registerValue(self, "saveFilename", name .. ".grle")
            THUtils.registerValue(self, "isInitialized", false)
            return self
        end
    end
end
function THInfoLayer.saveToFile(self, saveFilename, callbackFunc, callbackTarget, ...)
    if saveFilename == nil then
        saveFilename = self.saveFilename
    elseif type(saveFilename) ~= THValueType.STRING or saveFilename == "" then
        THUtils.errorMsg(true, THMessage.ARGUMENT_INVALID, "saveFilename", saveFilename)
    end
    if saveFilename ~= nil then
        return THUtils.callSuperClass(self, "saveToFile", true, saveFilename, callbackFunc, callbackTarget, ...)
    end
end
function THInfoLayer.initialize(self)
    return true
end